# Contribution guidelines

First off, thanks for taking the time to contribute!

The following is a set of guidelines for contributing to Feather. Feel free to propose changes to this document in a pull request.

## Pull requests

> [!IMPORTANT]
> We are not accepting pull requests containing **icons**. If you want to add a new icon, please create an [icon request](#icon-requests).

Pull requests for bug fixes and improvements are welcome. If you’re not sure if something is worth doing, please open an issue first.

**Working on your first Pull Request?** You can learn how from this _free_ series
[How to Contribute to an Open Source Project on GitHub](https://egghead.io/courses/how-to-contribute-to-an-open-source-project-on-github).

Here are a few things you can do that will increase the likelihood of your pull request being accepted:

- **Make your commit messages as descriptive as possible.** Include as much information as you can. Explain anything that might be unclear.
- **Document your pull request**. Explain your changes, link to the relevant issue, and add screenshots when applicable.
- **Include only related work**. If you have unrelated changes, please split them into separate pull requests.

## Icon requests

To request a new icon, please fill out the [icon request form](https://github.com/feathericons/feather/issues/new?template=01-icon-request.yml).

## Bug reports

To report a bug, please fill out the [bug report form](https://github.com/feathericons/feather/issues/new?template=02-bug-report.yml).
